﻿<?php
// OTA Admin (PULL) - usado pelo Super Admin
require_once __DIR__ . '/../admin/auth.php';
require_role('admin_master');
require_once __DIR__ . '/../api/db.php'; // $mysqli

// Storage
$storageDir = __DIR__ . '/storage';
if (!is_dir($storageDir)) {
  @mkdir($storageDir, 0755, true);
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$okMsg = null;
$errMsg = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $panel_keys = isset($_POST['panel_keys']) && is_array($_POST['panel_keys']) ? $_POST['panel_keys'] : [];
  $panel_keys = array_values(array_filter(array_map('trim', $panel_keys)));
  $version = isset($_POST['version']) ? trim($_POST['version']) : '';

  if (!$panel_keys) {
    $errMsg = 'Selecione ao menos 1 painel.';
  } elseif ($version === '') {
    $errMsg = 'Informe a versão.';
  } elseif (!isset($_FILES['firmware']) || $_FILES['firmware']['error'] !== UPLOAD_ERR_OK) {
    $errMsg = 'Selecione o arquivo firmware.bin.';
  } else {
    $tmp = $_FILES['firmware']['tmp_name'];
    $orig = $_FILES['firmware']['name'] ?? 'firmware.bin';

    $sha = hash_file('sha256', $tmp);
    $safeOrig = preg_replace('/[^A-Za-z0-9._-]/', '_', $orig);
    $binFile = 'firmware_' . date('Ymd_His') . '_' . substr($sha,0,12) . '_' . $safeOrig;
    $binPath = $storageDir . '/' . $binFile;

    if (!move_uploaded_file($tmp, $binPath)) {
      $errMsg = 'Falha ao salvar o arquivo no servidor.';
    } else {
      // dispara para cada painel
      $fired = [];
      foreach ($panel_keys as $pk) {
        $pkSafe = preg_replace('/[^A-Za-z0-9_-]/', '', $pk);
        if ($pkSafe === '') continue;

        $state = [
          'pending' => true,
          'version' => $version,
          'bin_file' => $binFile,
          'sha256' => $sha,
          'triggered_at' => date('c'),
          'triggered_by' => $_SESSION['user_id'] ?? null,
        ];
        $stateFile = $storageDir . '/state_' . $pkSafe . '.json';
        file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        $fired[] = $pkSafe;
      }

      $okMsg = 'OK! Atualização disparada para ' . implode(', ', $fired) . ' (versão ' . h($version) . ').';
    }
  }
}

// Carrega paineis ativos por cliente
$sql = "
  SELECT c.id AS client_id, c.name AS client_name,
         s.id AS store_id, s.name AS store_name,
         p.id AS panel_id, p.name AS panel_name, p.panel_key, p.is_active
  FROM panels p
  JOIN stores s ON s.id = p.store_id
  JOIN clients c ON c.id = s.client_id
  WHERE p.is_active=1
  ORDER BY c.name, s.name, p.name
";
$res = $mysqli->query($sql);
$groups = [];
if ($res) {
  while($r = $res->fetch_assoc()){
    $cid = (int)$r['client_id'];
    if (!isset($groups[$cid])) {
      $groups[$cid] = [
        'client_id' => $cid,
        'client_name' => $r['client_name'],
        'panels' => []
      ];
    }
    $groups[$cid]['panels'][] = $r;
  }
}

?><!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>OTA Admin (PULL)</title>
  <style>
    body{font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial; margin:0; background:#f6f7fb;}
    .wrap{max-width:1100px;margin:40px auto;padding:0 16px;}
    h1{margin:0 0 14px 0;}
    .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:16px;}
    .row{display:flex;gap:12px;flex-wrap:wrap;align-items:flex-end;}
    .field{flex:1 1 260px;min-width:260px;}
    label{display:block;font-size:13px;color:#374151;margin:0 0 6px 0;}
    input[type=text]{width:100%;padding:10px 12px;border:1px solid #d1d5db;border-radius:10px;}
    input[type=file]{width:100%;}
    button{background:#111827;color:#fff;border:none;border-radius:10px;padding:12px 14px;cursor:pointer;}
    button.secondary{background:#e5e7eb;color:#111827;}
    .msg{padding:12px 14px;border-radius:10px;margin-bottom:12px;}
    .ok{background:#ecfdf5;border:1px solid #a7f3d0;color:#065f46;}
    .err{background:#fef2f2;border:1px solid #fecaca;color:#991b1b;}
    .clientBox{margin-top:14px;}
    .clientHead{display:flex;justify-content:space-between;align-items:center;margin:0 0 8px 0;}
    .clientName{font-weight:700;}
    .panels{display:grid;grid-template-columns:repeat(auto-fit,minmax(260px,1fr));gap:10px;}
    .panelItem{border:1px solid #e5e7eb;border-radius:12px;padding:10px 12px;background:#fff;display:flex;gap:10px;}
    .panelItem small{color:#6b7280;display:block;}
    .panelItem b{display:block;}
    .topActions{display:flex;gap:10px;align-items:center;justify-content:flex-end;margin:10px 0 0 0;}
    .hint{color:#6b7280;font-size:13px;margin-top:8px;}
    a{color:#2563eb;text-decoration:none;}
    .links{margin-top:10px;font-size:13px;color:#6b7280;}
  </style>
</head>
<body>
  <div class="wrap">
    <h1>OTA Admin (PULL)</h1>

    <?php if ($okMsg): ?><div class="msg ok"><?php echo $okMsg; ?></div><?php endif; ?>
    <?php if ($errMsg): ?><div class="msg err"><?php echo h($errMsg); ?></div><?php endif; ?>

    <div class="card">
      <form method="post" enctype="multipart/form-data" id="otaForm">
        <div class="row">
          <div class="field">
            <label>Versão (ex: 5.0.1)</label>
            <input type="text" name="version" placeholder="V14 teste 2" required />
          </div>
          <div class="field">
            <label>firmware.bin (PlatformIO: .pio/build/esp32dev/firmware.bin)</label>
            <input type="file" name="firmware" accept=".bin" required />
          </div>
          <div style="flex:0 0 auto;">
            <button type="submit" style="width:auto;white-space:nowrap;">Disparar atualização</button>
          </div>
        </div>

        <div class="topActions">
          <button type="button" class="secondary" onclick="selectAll(true)">Selecionar todos</button>
          <button type="button" class="secondary" onclick="selectAll(false)">Limpar seleção</button>
        </div>

        <div class="hint">Selecione os painéis ativos que irão fazer o download do firmware via PULL.</div>

        <?php foreach($groups as $cid => $g): ?>
          <div class="clientBox">
            <div class="clientHead">
              <div class="clientName"><?php echo h($g['client_name']); ?></div>
              <div>
                <button type="button" class="secondary" onclick="selectClient(<?php echo (int)$cid; ?>, true)">Selecionar cliente</button>
                <button type="button" class="secondary" onclick="selectClient(<?php echo (int)$cid; ?>, false)">Limpar cliente</button>
              </div>
            </div>
            <div class="panels">
              <?php foreach($g['panels'] as $p): ?>
                <label class="panelItem">
                  <input type="checkbox" class="pk" data-client="<?php echo (int)$cid; ?>" name="panel_keys[]" value="<?php echo h($p['panel_key']); ?>" />
                  <div>
                    <b><?php echo h($p['panel_name']); ?> <small>(<?php echo h($p['panel_key']); ?>)</small></b>
                    <small><?php echo h($p['store_name']); ?></small>
                    <small>
                      Check: <a href="check.php?panel_key=<?php echo urlencode($p['panel_key']); ?>" target="_blank">abrir</a> ·
                      Download: <a href="download.php?panel_key=<?php echo urlencode($p['panel_key']); ?>" target="_blank">abrir</a>
                    </small>
                  </div>
                </label>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endforeach; ?>

        <div class="links">
          Dica: proteja esta página com senha (htaccess) ou mantenha o acesso apenas via Admin Master.
        </div>
      </form>
    </div>
  </div>

<script>
  function selectAll(on){
    document.querySelectorAll('input.pk').forEach(cb => cb.checked = !!on);
  }
  function selectClient(cid, on){
    document.querySelectorAll('input.pk[data-client="'+cid+'"]').forEach(cb => cb.checked = !!on);
  }
</script>
</body>
</html>

