<?php
// OTA ADMIN SIMPLES (SEM BANCO) - LEDsmart
// 1) Faça upload do firmware.bin (PlatformIO: .pio/build/esp32dev/firmware.bin)
// 2) Escolha panel_key e versão
// 3) Clique "Disparar atualização"
//
// Segurança: proteja esta pasta por senha (.htaccess) ou mova para área admin do seu portal.

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

$storage = __DIR__ . '/storage';
if (!is_dir($storage)) mkdir($storage, 0755, true);

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $panel_key = isset($_POST['panel_key']) ? preg_replace('/[^A-Z0-9\-\_]/i','', $_POST['panel_key']) : '';
  $version   = isset($_POST['version']) ? trim($_POST['version']) : '';

  if ($panel_key === '' || $version === '') {
    $msg = 'Preencha panel_key e version.';
  } else if (!isset($_FILES['bin']) || $_FILES['bin']['error'] !== UPLOAD_ERR_OK) {
    $msg = 'Envie o arquivo .bin.';
  } else {
    $tmp = $_FILES['bin']['tmp_name'];
    $binName = 'fw_' . $panel_key . '_' . time() . '.bin';
    $binPath = $storage . '/' . $binName;

    if (!move_uploaded_file($tmp, $binPath)) {
      $msg = 'Falha ao mover o arquivo.';
    } else {
      $sha256 = hash_file('sha256', $binPath);
      $state = [
        'pending'  => true,
        'panel_key'=> $panel_key,
        'version'  => $version,
        'bin_file' => $binName,
        'sha256'   => $sha256,
        'updated_at'=> date('c'),
      ];
      file_put_contents(__DIR__ . '/storage/state_' . $panel_key . '.json', json_encode($state, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
      $msg = 'OK! Atualização disparada para ' . $panel_key . ' (versão ' . $version . ').';
    }
  }
}
?><!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>OTA Admin - LEDsmart</title>
  <style>
    body{font-family:system-ui,Segoe UI,Roboto,Arial;max-width:720px;margin:40px auto;padding:0 16px;}
    .card{border:1px solid #ddd;border-radius:12px;padding:18px;}
    input,button{width:100%;padding:12px;border-radius:10px;border:1px solid #ccc;font-size:16px;}
    button{background:#111;color:#fff;border:none;cursor:pointer;margin-top:10px;}
    .msg{margin:12px 0;padding:10px;border-radius:10px;background:#f5f5f5;}
    small{color:#555}
  </style>
</head>
<body>
  <h2>OTA Admin (PULL)</h2>
  <div class="card">
    <?php if($msg): ?><div class="msg"><?php echo h($msg); ?></div><?php endif; ?>
    <form method="post" enctype="multipart/form-data">
      <label><small>panel_key (ex: PAINEL-001)</small></label>
      <input name="panel_key" required value="<?php echo isset($_POST['panel_key'])?h($_POST['panel_key']):''; ?>">
      <br><br>
      <label><small>version (ex: 5.0.1)</small></label>
      <input name="version" required value="<?php echo isset($_POST['version'])?h($_POST['version']):''; ?>">
      <br><br>
      <label><small>firmware.bin (PlatformIO: .pio/build/esp32dev/firmware.bin)</small></label>
      <input type="file" name="bin" accept=".bin,application/octet-stream" required>
      <button type="submit">Disparar atualização</button>
    </form>
    <p><small>Dica: proteja esta página com senha (htaccess) ou mova para a área admin do portal.</small></p>
    <p><small>Check: /check.php?panel_key=PAINEL-001</small></p>
    <p><small>Download: /download.php?panel_key=PAINEL-001</small></p>
  </div>
</body>
</html>